\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{komunikaciepaper}[2026/2/19 v0.3 Comma authors NO LINES]

% Force two-column mode
\newif\if@twocolumn \@twocolumntrue
\DeclareOption{singlecolumn}{\@twocolumnfalse}
\DeclareOption{draft}{\PassOptionsToClass{draft}{article}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\if@twocolumn
  \LoadClass[10pt,twocolumn]{article}
\else
  \LoadClass[10pt]{article}
\fi

% Essential packages AFTER class load
\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage[english]{babel}
\RequirePackage{amsmath,amssymb}
\RequirePackage{graphicx}
\RequirePackage{booktabs}
\RequirePackage[numbers]{natbib}
\RequirePackage{hyperref}
\RequirePackage{titlesec}
\RequirePackage{fancyhdr}
\RequirePackage{geometry}
\RequirePackage{subfig}
\RequirePackage{caption}
\RequirePackage{makecell}
\RequirePackage{float}
\RequirePackage{tabularx}
\RequirePackage{multirow}
\RequirePackage{array}
\RequirePackage{cuted}
\RequirePackage{lipsum}

% Text + math in Times-like fonts
\RequirePackage{newtxtext}   % or: \RequirePackage{mathptmx}
%\RequirePackage{newtxmath}

% Fix ORCID hyperlink alignment
\newcommand{\orcid}[1]{%
  \begingroup
  \small
  \href{https://orcid.org/#1}{#1}%
  \endgroup
}

% Page geometry for two-column
\geometry{
  a4paper,
  left=2.5cm,
  right=2.5cm,
  top=2.5cm,
  bottom=2.5cm,
  footskip=1cm,
  columnsep=0.75cm
}

% Table settings
\captionsetup[table]{%
  font=it,
  labelfont={bf,it},         % "Table 1" bold+italic
  justification=raggedright,
  singlelinecheck=false,
  labelsep=space             % "Table 1 Filter Performance..." (no colon)
}

% Fonts and spacing
\renewcommand{\normalsize}{\fontsize{9}{11}\selectfont}
\renewcommand{\baselinestretch}{1.0}

% Section formatting
\titleformat{\section}{\large\bfseries}{\thesection}{1em}{}
\titleformat{\subsection}{\normalsize\bfseries}{\thesubsection}{1em}{}

% Headers/footers
% \pagestyle{fancy}
% \fancyhf{}
% \fancyfoot[C]{\thepage}

% Custom title command - NO LINES, comma-separated authors
% Set base font to exactly 9pt everywhere
\renewcommand{\normalsize}{\fontsize{9}{11}\selectfont}
\renewcommand{\small}{\fontsize{9}{11}\selectfont}
\renewcommand{\footnotesize}{\fontsize{9}{11}\selectfont}

\newcommand{\sensorTitle}[4]{%
  \twocolumn[%
    \vskip 3em%
    {\raggedright
      {\fontsize{18.5pt}{22pt}\bfseries #1 \par}% title only larger
      \vspace{1.2em}%
      #2\par% authors/affiliations/ORCID - exactly 9pt
      \vspace{1.8em}%
      \noindent\rule{\textwidth}{0.4pt}\\[0.6em]
      \begin{tabular}{p{0.70\textwidth} p{0.28\textwidth}}
        \textbf{Abstract:} #3 &
        \textbf{Keywords:} #4
      \end{tabular}\\[0.6em]
      \rule{\textwidth}{0.4pt}
    \par}%
    \vspace{1.2em}%
  ]%
}

\newenvironment{myitemize}
{ \begin{itemize}
    \setlength{\itemsep}{0pt}
    \setlength{\parskip}{0pt}
    \setlength{\parsep}{0pt}     }
{ \end{itemize}                  } 

% Custom commands
%\newcommand{\orcid}[1]{\href{https://orcid.org/#1}{ORCID: #1}}
\newcommand{\affil}[2]{#1\orcid{#2}}